#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Simple Infinite MazeMod01.fsh   by   johnao
//https://www.shadertoy.com/view/NsycDm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define N 40
#define PRECISION .001

float rand(vec2 p) {
    return fract(sin(dot(p, vec2(1.234, 56.78))) * 87654.3);
}

vec2 map(vec3 p) {
    vec2 ip = floor(p.xz);
    vec2 fp = p.xz - ip;
    float d = (rand(ip) < .5 ? abs(fp.x + fp.y - 1.) : -abs(fp.x - fp.y)) * .707;
    vec2 cp = vec2(.5) - abs(fp - vec2(.5));
    float d2 = max(max(cp.x, cp.y) * .7, min(cp.x, cp.y) * 1.4);
    d = d < 0. ? max(-d2, d) : min(d2, d);
    if (abs(d) < p.y) {
        return vec2(abs(d), p.y > .95 ? 2. : (d > 0. ? 0. : 1.));
    } else {
        return vec2(p.y, 2.);
    }
}

vec3 scene(vec2 coord) {
    vec2 uv = (2. * coord - iResolution.xy) / min(iResolution.x, iResolution.y);
    vec3 o = vec3(iTime, 3., -iTime);
    vec3 d = normalize(vec3(uv.x, -1. + uv.y * .707, -2. - uv.y * .707));
    float t = .2 * iTime;
    float ct = cos(t), st = sin(t);
    d = vec3(d.x * ct - d.z * st, d.y, d.x * st + d.z * ct);
    vec3 col = vec3(0.);
    if (d.y < 0.) {
        float l = (o.y - 1.) / -d.y;
        vec3 p = o + l * d;
        vec2 m;
        for (int i = 0; i < N; ++i) {
            m = map(p);
            if (m.x < PRECISION) {
                break;
            }
            l += m.x;
            p = o + l * d;
        }
        if (m.y < .5) {
            col = vec3(0.7529, 0.2157, 0.3333);
        } else if (m.y < 1.5) {
            col = vec3(0.);
        } else if (m.y < 2.5) {
            col = vec3(0.6353, 0.5686, 0.6588);
        }
    }
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // simple AA
    vec3 col = .25 * (scene(fragCoord.xy + vec2(.1, .4)) + scene(fragCoord.xy + vec2(-.4, .1)) + scene(fragCoord.xy + vec2(-.1, -.4)) + scene(fragCoord.xy + vec2(.4, -.1)));
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

